//
//  ViewController.m
//  Deleting Cells and Sections from Table Views
//
//  Created by Vandad Nahavandipoor on 12/11/2011.
//  Copyright (c) 2011 Pixolity Ltd. All rights reserved.
//

#import "ViewController.h"

@implementation ViewController
@synthesize tableViewNumbers;
@synthesize dictionaryOfNumbers;
@synthesize barButtonAction;

static NSString *SectionOddNumbers = @"Liczby nieparzyste";
static NSString *SectionEvenNumbers = @"Liczby parzyste";

#pragma mark - Table View Data Source
- (NSInteger) numberOfSectionsInTableView:(UITableView *)tableView{
  
  NSInteger result = 0;
  result = [[self.dictionaryOfNumbers allKeys] count];
  return result;
  
}

- (NSInteger) tableView:(UITableView *)tableView
  numberOfRowsInSection:(NSInteger)section{
  
  NSInteger result = 0;
  NSString *sectionNameInDictionary = [[self.dictionaryOfNumbers allKeys] 
                                       objectAtIndex:section];
  NSArray *sectionArray = [self.dictionaryOfNumbers objectForKey:
                           sectionNameInDictionary];
  result = [sectionArray count];
  return result;
  
}

- (UITableViewCell *) tableView:(UITableView *)tableView 
          cellForRowAtIndexPath:(NSIndexPath *)indexPath{
  
  UITableViewCell *result = nil;
  
  static NSString *CellIdentifier = @"NumbersCellIdentifier";
  
  result = [tableView dequeueReusableCellWithIdentifier:CellIdentifier];
  
  if (result == nil){
    result = [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleDefault 
                                    reuseIdentifier:CellIdentifier];
  }
  
  NSString *sectionNameInDictionary = [[self.dictionaryOfNumbers allKeys] 
                                       objectAtIndex:indexPath.section];
  NSArray *sectionArray = [self.dictionaryOfNumbers objectForKey:
                           sectionNameInDictionary];
  NSNumber *number = [sectionArray objectAtIndex:indexPath.row];
  
  result.textLabel.text = [NSString stringWithFormat:@"%lu", 
                           (unsigned long)[number unsignedIntegerValue]];
  
  return result;
  
}

- (NSString *) tableView:(UITableView *)tableView 
 titleForHeaderInSection:(NSInteger)section{
  
  NSString *result = nil;
  result = [[self.dictionaryOfNumbers allKeys] objectAtIndex:section];  
  return result;
  
}

#pragma mark - Populating the Data Source Dictionary
- (void) constructDictionaryOfNumbers{
  
  self.dictionaryOfNumbers = [[NSMutableDictionary alloc] init];
  
  NSMutableArray *arrayOfEvenNumbers = [[NSMutableArray alloc] initWithObjects:
                                        [NSNumber numberWithUnsignedInteger:0],
                                        [NSNumber numberWithUnsignedInteger:2],
                                        [NSNumber numberWithUnsignedInteger:4],
                                        [NSNumber numberWithUnsignedInteger:6], 
                                        nil];
  
  NSMutableArray *arrayOfOddNumbers = [[NSMutableArray alloc] initWithObjects:
                                       [NSNumber numberWithUnsignedInteger:1],
                                       [NSNumber numberWithUnsignedInteger:3],
                                       [NSNumber numberWithUnsignedInteger:5],
                                       [NSNumber numberWithUnsignedInteger:7], 
                                       nil];
  
  [self.dictionaryOfNumbers setObject:arrayOfEvenNumbers 
                             forKey:SectionEvenNumbers];
  
  [self.dictionaryOfNumbers setObject:arrayOfOddNumbers 
                             forKey:SectionOddNumbers];
  
}

/* 1 */
//- (void) deleteOddNumbersSection:(id)paramSender{
//  
//  /* W pierwszej kolejności usuwamy sekcję ze źródła danych. */
//  NSString *key = SectionOddNumbers;
//  NSInteger indexForKey = [[self.dictionaryOfNumbers allKeys] 
//                           indexOfObject:key];
//  if (indexForKey == NSNotFound){
//    NSLog(@"Nie można znaleźć sekcji w źródle danych.");
//    return;
//  }
//  [self.dictionaryOfNumbers removeObjectForKey:key];
//  
//  /* Następnie usuwamy sekcję z widoku tabeli. */
//  NSIndexSet *sectionToDelete = [NSIndexSet indexSetWithIndex:indexForKey];
//  [self.tableViewNumbers deleteSections:sectionToDelete
//                     withRowAnimation:UITableViewRowAnimationAutomatic];
//  
//  /* Na końcu usuwamy przycisk z paska nawigacyjnego ponieważ nie będzie on dłużej potrzebny. */
//  [self.navigationItem setRightBarButtonItem:nil animated:YES];
//  
//}
//
//- (void)viewDidLoad
//{
//  [super viewDidLoad];
//  
//  [self constructDictionaryOfNumbers];
//  
//  self.barButtonAction = 
//  [[UIBarButtonItem alloc] initWithTitle:@"Usuń liczby nieparzyste"
//                                   style:UIBarButtonItemStylePlain
//                                  target:self
//                                  action:@selector(deleteOddNumbersSection:)];
//  [self.navigationItem setRightBarButtonItem:self.barButtonAction animated:NO];
//  
//  self.tableViewNumbers = [[UITableView alloc] 
//                           initWithFrame:self.view.frame
//                           style:UITableViewStyleGrouped];
//  self.tableViewNumbers.autoresizingMask = UIViewAutoresizingFlexibleWidth | 
//                                           UIViewAutoresizingFlexibleHeight;
//  self.tableViewNumbers.delegate = self;
//  self.tableViewNumbers.dataSource = self;
//  [self.view addSubview:self.tableViewNumbers];
//  
//}
//
//- (void)viewDidUnload
//{
//  [super viewDidUnload];
//  //  Usunięcie wszystkich "przytrzymanych" podwidoków widoku głównego.
//  [self setTableViewNumbers:nil];
//  [self setDictionaryOfNumbers:nil];
//  [self setBarButtonAction:nil];
//}


/* 2 */
- (void) deleteNumbersGreaterThan2:(id)paramSender{
  
  NSMutableArray *arrayOfIndexPathsToDelete = [[NSMutableArray alloc] init];
  NSMutableArray *arrayOfNumberObjectsToDelete = [[NSMutableArray alloc] init];
  
    /* Krok 1: zebranie obiektów przeznaczonych do usunięcia ze źródła danych
     oraz ich ścieżek indeksu. */
  __block NSUInteger keyIndex = 0;
  [self.dictionaryOfNumbers enumerateKeysAndObjectsUsingBlock:
   ^(NSString *key, NSMutableArray *object, BOOL *stop) {
     
     [object enumerateObjectsUsingBlock:
      ^(NSNumber *number, NSUInteger numberIndex, BOOL *stop) {
        
        if ([number unsignedIntegerValue] > 2){
          NSIndexPath *indexPath = [NSIndexPath indexPathForRow:numberIndex
                                                      inSection:keyIndex];
          [arrayOfIndexPathsToDelete addObject:indexPath];
          [arrayOfNumberObjectsToDelete addObject:number];
        }
        
     }];
     
     keyIndex++;
  }];
  
  /* Krok 2: usunięcie obiektów ze źródła danych. */
  if ([arrayOfNumberObjectsToDelete count] > 0){
    NSMutableArray *arrayOfOddNumbers = [self.dictionaryOfNumbers 
                                         objectForKey:SectionOddNumbers];
    NSMutableArray *arrayOfEvenNumbers = [self.dictionaryOfNumbers
                                          objectForKey:SectionEvenNumbers];
    [arrayOfNumberObjectsToDelete enumerateObjectsUsingBlock:
     ^(NSNumber *numberToDelete, NSUInteger idx, BOOL *stop) {
       if ([arrayOfOddNumbers indexOfObject:numberToDelete] != NSNotFound){
         [arrayOfOddNumbers removeObject:numberToDelete];
       }
       if ([arrayOfEvenNumbers indexOfObject:numberToDelete] != NSNotFound){
         [arrayOfEvenNumbers removeObject:numberToDelete];
       }
       [arrayOfEvenNumbers removeObject:numberToDelete];
    }];
  }
  
  /* Krok 3: usunięcie komórek odpowiadających obiektom. */
  NSArray *arrayOfPaths = [[NSArray alloc] 
                           initWithArray:arrayOfIndexPathsToDelete];
  [self.tableViewNumbers 
   deleteRowsAtIndexPaths:arrayOfPaths
   withRowAnimation:UITableViewRowAnimationAutomatic];
  
  [self.navigationItem setRightBarButtonItem:nil animated:YES];
  
}

- (void)viewDidLoad
{
  [super viewDidLoad];
  
  [self constructDictionaryOfNumbers];
  
  self.barButtonAction = 
  [[UIBarButtonItem alloc] initWithTitle:@"Usuń liczby większe niż 2"
                                   style:UIBarButtonItemStylePlain
                                  target:self
                                  action:@selector(deleteNumbersGreaterThan2:)];
  [self.navigationItem setRightBarButtonItem:self.barButtonAction animated:NO];
  
  self.tableViewNumbers = [[UITableView alloc] 
                         initWithFrame:self.view.frame
                         style:UITableViewStyleGrouped];
  self.tableViewNumbers.autoresizingMask = UIViewAutoresizingFlexibleWidth | 
  UIViewAutoresizingFlexibleHeight;
  self.tableViewNumbers.delegate = self;
  self.tableViewNumbers.dataSource = self;
  [self.view addSubview:self.tableViewNumbers];
  
}

- (void)viewDidUnload
{
  [super viewDidUnload];
  //  Usunięcie wszystkich "przytrzymanych" podwidoków widoku głównego.
  [self setTableViewNumbers:nil];
  [self setDictionaryOfNumbers:nil];
  [self setBarButtonAction:nil];
}

- (BOOL)shouldAutorotateToInterfaceOrientation:
        (UIInterfaceOrientation)interfaceOrientation
{
  return YES;
}

@end
